/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWUDDIRegistryManager;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import filenet.vw.toolkit.utils.ws.contact.VWUDDIBusinessContactsPanel;
import filenet.vw.toolkit.utils.ws.general.VWUDDIBusinessGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;

public final class VWUDDIBusinessDetailsPanel
extends JPanel
implements ChangeListener {
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private Component m_currentSelectedTab = null;
    private Frame m_parentFrame = null;
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private VWUDDIBusinessGeneralPanel m_businessGeneralPanel = null;
    private VWUDDIBusinessContactsPanel m_businessContactsPanel = null;
    private Vector m_contacts = null;
    private VWUDDIRegistryManager m_uddiRegistryManager = null;
    private int m_currentContact = -1;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 09:15:54  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    public VWUDDIBusinessDetailsPanel(Frame parent, VWSession session, VWUDDIRegistryManager uddiRegistryManager, VWUDDIBusinessItem businessItem) {
        this.m_parentFrame = parent;
        this.m_uddiRegistryManager = uddiRegistryManager;
        this.m_tabbedPanel.addChangeListener(this);
        this.m_vwBusinessItem = businessItem;
        this.createControls();
    }

    private void createControls() {
        try {
            Font aFont = this.getFont();
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.setLayout(new BorderLayout(3, 3));
            this.m_tabbedPanel.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
            this.m_businessGeneralPanel = new VWUDDIBusinessGeneralPanel(this.m_parentFrame, this.m_vwBusinessItem);
            this.m_tabbedPanel.add(VWResource.s_general, this.m_businessGeneralPanel);
            VWAccessibilityHelper.setAccessibility(this.m_businessGeneralPanel, this, VWResource.s_general, VWResource.s_general);
            Contacts contactList = this.m_vwBusinessItem.getContacts();
            BusinessEntity regionBusinessEntity = this.m_uddiRegistryManager.getRegionBusinessEntity();
            this.m_businessContactsPanel = new VWUDDIBusinessContactsPanel(this.m_parentFrame, this.m_vwBusinessItem, regionBusinessEntity);
            this.m_tabbedPanel.add(VWResource.s_contacts, this.m_businessContactsPanel);
            VWAccessibilityHelper.setAccessibility(this.m_businessContactsPanel, this, VWResource.s_contacts, VWResource.s_contacts);
            this.add((Component)this.m_tabbedPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_businessGeneralPanel.addBusinessStatusListener(listener);
        this.m_businessContactsPanel.addBusinessStatusListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateBusinessDetailPanel(VWUDDIRegistryItem registryItem, VWUDDIBusinessItem businessItem) {
        block7: {
            this.m_vwBusinessItem = businessItem;
            Cursor currentCursor = null;
            try {
                try {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_businessGeneralPanel.updateGeneralInfo(this.m_vwBusinessItem);
                    this.m_businessContactsPanel.updateContactInfo(this.m_vwBusinessItem);
                    this.updateUI();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var6_5 = null;
                    if (currentCursor != null) {
                        this.setCursor(currentCursor);
                    }
                    this.updateUI();
                    return;
                }
                Object var6_4 = null;
                if (currentCursor == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (currentCursor != null) {
                    this.setCursor(currentCursor);
                }
                this.updateUI();
                throw throwable;
            }
            this.setCursor(currentCursor);
        }
        this.updateUI();
    }

    public boolean update() {
        boolean bSuccess = false;
        try {
            bSuccess = this.m_businessGeneralPanel.update();
            if (bSuccess) {
                bSuccess = this.m_businessContactsPanel.update();
            }
            Contacts contacts = this.m_businessContactsPanel.getContacts();
            this.m_vwBusinessItem.setContacts(contacts);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    private void updateContact() {
        try {
            Object obj;
            Contact contact = null;
            if (this.m_currentContact != -1 && this.m_contacts != null && this.m_currentContact < this.m_contacts.size() && this.m_contacts != null && this.m_contacts.size() > 0 && (obj = this.m_contacts.get(this.m_currentContact)) != null && obj instanceof Contact) {
                contact = (Contact)obj;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    void setBusinessDisplayMode(VWUDDIRegistryItem registryItem) {
    }

    public void stateChanged(ChangeEvent event) {
        boolean bOk = true;
        Object sourceObject = event.getSource();
        if (sourceObject == this.m_tabbedPanel) {
            if (this.m_currentSelectedTab != null) {
                // empty if block
            }
            Component aComponent = this.m_tabbedPanel.getSelectedComponent();
            if (bOk) {
                // empty if block
            }
            this.m_currentSelectedTab = aComponent;
        }
    }
}

